<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Ultimate Media Gallery v1.4.3                                          # ||
|| #                                                                        # ||
|| # ---------------------------------------------------------------------- # ||
|| # Copyright  2008-2009 pHp-unlimited. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| # It's not allowed to delete this Information.                           # ||
|| ########################################################################## ||
\*============================================================================*/

$errors = array ();
$globals = array (
	'query'           => TYPE_STR,
	'pagenumber'      => TYPE_INT,
	'perpage'         => TYPE_INT,
	'searchuser'      => TYPE_STR,
	'sc'              => TYPE_STR,
	'mediatype'       => TYPE_STR,
	'exactname'       => TYPE_BOOL,
	'starteronly'     => TYPE_BOOL,
	'tag'             => TYPE_STR,
	'tags'            => TYPE_STR,
	'categorychoice'  => TYPE_ARRAY,
	'childcategories' => TYPE_BOOL,
	'titleonly'       => TYPE_BOOL,
	'showposts'       => TYPE_BOOL,
	'searchdate'      => TYPE_NOHTML,
	'beforeafter'     => TYPE_NOHTML,
	'sortby'          => TYPE_NOHTML,
	'sortorder'       => TYPE_NOHTML,
	'replyless'       => TYPE_UINT,
	'replylimit'      => TYPE_UINT,
	'quicksearch'     => TYPE_BOOL,
	'humanverify'     => TYPE_ARRAY,
	'userid'          => TYPE_UINT,
);
$vbulletin->input->clean_array_gpc ('r', $globals);

$replylimit = $vbulletin->GPC['replylimit'];
if ($replylimit <= 0 OR $replylimit == '') $replylimit = 0;

$gallery_media_types[] = 'gif';
$gallery_media_types[] = 'jpg';
$gallery_media_types[] = 'png';
$gallery_media_types[] = 'jpeg';
$gallery_media_types[] = 'url';

sort ($gallery_media_types, SORT_STRING);
$media_select = "<option value=\"\">---</option>\n";
foreach ($gallery_media_types as $key => $option)
{
	$sel = '';
	if ($vbulletin->GPC['mediatype'] == $option) $sel = ' selected="selected"';
	$media_select .= "<option value=\"" . $option . "\"" . $sel . ">" . $option . "</option>\n";
}

require_once (DIR . '/includes/functions_search.php');

if ($vbulletin->GPC['tags'] != '')
{
	$vbulletin->GPC['query'] = '';
	$vbulletin->GPC['act'] = 'find';
	$vbulletin->GPC['quicksearch'] = 0;
	$vbulletin->GPC['tag'] = $vbulletin->GPC['tags'];
}

if ($vbulletin->GPC['act'] == 'find')
{
	$lim = 20;

	$tag_search = '';
	require_once (DIR . '/includes/functions_misc.php');
	$searchstart = microtime ();

	$search['user'] = false;
	if ($vbulletin->GPC['quicksearch'])
	{
		$need_category = true;
		$order_by = "ORDER BY ca.title ASC ";
		$displayWords = trim ($vbulletin->GPC['query']);
		$search_by_commentcount = $search_in_category = $search_by_date = '';
		if (strlen (trim ($vbulletin->GPC['query'])) <= 3)
		{
			$errors[] = $vbphrase['umg_error_keyword_too_short'];
		}
		$vbulletin->GPC['categorychoice'] = array (0);
		$more_title_search = "m.title LIKE '%" . $vbulletin->GPC['query'] . "%' ";
	}
	else
	{
		// if we use a keyword search in categories
		$need_category = false;
		if ($vbulletin->GPC['query'])
		{
			$need_category = true;
			$displayWords = trim ($vbulletin->GPC['query']);
			if (strlen (trim ($vbulletin->GPC['query'])) <= 3)
			{
				$errors[] = $vbphrase['umg_error_keyword_too_short'];
			}
		}
		else
		{
			// tag or username
			$vbulletin->GPC['titleonly'] = 1;
			if ($vbulletin->GPC['searchuser'] == '' AND $vbulletin->GPC['tag'] == '' AND $vbulletin->GPC['mediatype'] == '')
			{
				$errors[] = $vbphrase['umg_error_no_username_or_keyword'];
			}
			else if ($vbulletin->GPC['searchuser'])
			{
				// username too short
				if (!$vbulletin->GPC['exactname'] AND strlen ($vbulletin->GPC['searchuser']) < 3)
				{
					$errors[] = $vbphrase['umg_error_username_too_short'];
				}
				else
				{
					$username = htmlspecialchars_uni ($vbulletin->GPC['searchuser']);
					$q = "SELECT userid, username FROM " . TABLE_PREFIX . "user AS user WHERE username " . 
						($vbulletin->GPC['exactname'] ? "= '" . $db->escape_string ($username) . "'" : "LIKE('%" . sanitize_word_for_sql ($username) . "%')
					");

					require_once(DIR . '/includes/functions_bigthree.php');
					$coventry = fetch_coventry();

					$users = $db->query_read_slave ($q);
					if ($db->num_rows ($users))
					{
						$unams = $userids = array ();
						while ($user = $db->fetch_array ($users))
						{
							$postsum += $user['posts'];
							$unams[] = $user['username'];
							$userids[] = (in_array ($user['userid'], $coventry)) ? -1 : $user['userid'];
						}
						$userids = implode (', ', $userids);
						$more_title_search = "m.userid IN (" . $userids . ") ";
						$search['user'] = true;
						$displayUsers = implode (', ', $unams);
					}
					else
					{
						$errors[] = $vbphrase['umg_error_invalid_userid'];
					}
				}
			}
			else if ($vbulletin->GPC['mediatype'])
			{
				$need_category = false;
				$search['user'] = true;
				$order_by = "ORDER BY ca.title ASC ";
				$search_by_commentcount = $search_in_category = $search_by_date = '';

				$more_title_search = "m.filetype='" . $db->escape_string ($vbulletin->GPC['mediatype']) . "' ";
			}
			else if ($vbulletin->GPC['tag'])
			{
				$need_category = false;
				$search['user'] = true;
				$order_by = "ORDER BY ca.title ASC ";
				$search_by_commentcount = $search_in_category = $search_by_date = '';

				$tag_search  = "LEFT JOIN " . TABLE_PREFIX . "umg_tagmedia AS tm ON (tm.mediaid=m.mediaid) ";
				$tag_search .= "LEFT JOIN " . TABLE_PREFIX . "umg_tag AS t ON (t.tagid=tm.tagid) ";
				$more_title_search = "t.tagtext='" . $db->escape_string ($vbulletin->GPC['tag']) . "' ";
				$display_tag = $vbulletin->GPC['tag'];
			}
		}
	}

	$search_in_category = '';
	if (!count ($vbulletin->GPC['categorychoice']))
	{
		$vbulletin->GPC['categorychoice'] = explode (',', $vbulletin->GPC['sc']);
	}

	if ($need_category AND !count ($vbulletin->GPC['categorychoice']))
	{
		$errors[] = $vbphrase['umg_error_no_category_selected'];
	}

	if (empty ($errors))
	{
		if (count ($vbulletin->GPC['categorychoice']))
		{
			$cids = array ();
			$search_in_category = '';
			foreach ($vbulletin->GPC['categorychoice'] AS $key => $categoryid)
			{
				if (ereg ('u.', $categoryid))
				{
					// we checked the USERNAME instead of a category
					$uid = intval (str_replace ('u.', '', $categoryid));
					$category_list = $parent_list = array ();
					umg_get_categories ($category_list, $parent_list, -1, -1, $uid);
					foreach ($category_list AS $user_key => $user_catid)
					{
						if ($user_catid) $cids[] = $user_catid;
					}
				}
				else
				{
					if (!$vbulletin->GPC['childcategories'])
					{
						$cids[] = $categoryid;
					}
					else
					{
						// get our child categories
						if ($categoryid)
						{
							if (!in_array ($categoryid, $cids))
							{
								$cids[] = $categoryid;
								$category_list = $parent_list = array ();
								$cat = $db->query_first ("SELECT userid FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $categoryid);
								umg_get_categories ($category_list, $parent_list, $categoryid, -1, $cat['userid']);
								foreach ($category_list AS $user_key => $user_catid)
								{
									if ($user_catid) $cids[] = $user_catid;
								}
							}
						}
					}
				}
			}
			$cids = array_unique ($cids);

			if ((count ($cids) == 1 AND ($cids[0] == 0 OR $cids[0] = '')) OR empty ($cids))
			{
			}
			else
			{
				$catids = '0,' . implode (',', $cids);
				$search_in_category = "AND ca.catid IN (" . $catids . ") ";
			}
		}

		if (!$search['user'])
		{
			// only when we search for a query (not for users or tags)
			if (!$vbulletin->GPC['titleonly'])
			{
				$more_title_search = "
					(m.title LIKE '%" . $db->escape_string ($vbulletin->GPC['query']) . "%' 
					 OR m.description LIKE '%" . $db->escape_string ($vbulletin->GPC['query']) . "%' 
					 OR c.title LIKE '%" . $db->escape_string ($vbulletin->GPC['query']) . "%' 
					 OR c.comment LIKE '%" . $db->escape_string ($vbulletin->GPC['query']) . "%') 
				";
			}
			else
			{
				$more_title_search = "m.title LIKE '%" . $db->escape_string ($vbulletin->GPC['query']) . "%' ";
			}
		}

		// replyless
		$search_by_commentcount = '';
		if (!$vbulletin->GPC['replyless'] AND $vbulletin->GPC['replylimit'] > 0)
		{
			$search_by_commentcount = "AND co.commentcount>=" . $vbulletin->GPC['replylimit'];
		}
		else if ($vbulletin->GPC['replyless'] AND $vbulletin->GPC['replylimit'] > 0)
		{
			$search_by_commentcount = "AND co.commentcount<=" . $vbulletin->GPC['replylimit'];
		}

		// search for date
		$search_by_date = '';
		if ($vbulletin->GPC['searchdate'])
		{
			$datecut = TIMENOW - $vbulletin->GPC['searchdate'] * 86400;
			if ($datecut)
			{
				switch ($vbulletin->GPC['beforeafter'])
				{
					case 'before':
						$search_by_date = "AND (m.dateline<" . $datecut . " OR c.dateline<" . $datecut . ") ";
						if ($vbulletin->GPC['titleonly']) $search_by_date = "AND m.dateline<" . $datecut . " ";
						break;
					default:
						$search_by_date = "AND (m.dateline>" . $datecut . " OR c.dateline>" . $datecut . ") ";
						if ($vbulletin->GPC['titleonly']) $search_by_date = "AND m.dateline>" . $datecut . " ";
				}
			}
			unset ($datecut);
		}

		// sort by
		switch($vbulletin->GPC['sortorder'])
		{
			case 'ascending':
				$vbulletin->GPC['sortorder'] = 'ASC';
				break;
			default:
				$vbulletin->GPC['sortorder'] = 'DESC';
				break;
		}

		switch ($vbulletin->GPC['sortby'])
		{
			case 'username':
				$order_by = "ORDER BY u.username " . $vbulletin->GPC['sortorder'];
				break;
			case 'category':
				$order_by = "ORDER BY ca.title " . $vbulletin->GPC['sortorder'];
				break;
			case 'views':
				$order_by = "ORDER BY m.counter " . $vbulletin->GPC['sortorder'];
				break;
			case 'comments':
				$order_by = "ORDER BY co.commentcount " . $vbulletin->GPC['sortorder'];
				break;
			case 'upload':
				$order_by = "ORDER BY m.dateline " . $vbulletin->GPC['sortorder'];
				break;
			case 'rating':
				$order_by = "ORDER BY co.commentcount " . $vbulletin->GPC['sortorder'];
				break;
			default:
				$order_by = "ORDER BY ca.title ASC";
				break;
		}
	}

	if (!empty ($errors))
	{
		$show['errors'] = true;
		$show['search'] = $show['results'] = false;
	}
	else
	{

		$mcolspan = 7;
		$show['umg_lastcom'] = $show['umg_thumbs'] = $show['umg_comments'] = true;
		$catstyle = explode (',', $vbulletin->userinfo['umgstyle']);
		if (!$catstyle[1] OR !$vbulletin->options['umg_start_thumbs']) { $show['umg_thumbs'] = false; $mcolspan--; }
		if (!$catstyle[3] OR !$vbulletin->options['umg_start_comments']) { $show['umg_comments'] = false; $mcolspan--; }
		if (!$catstyle[4] OR !$vbulletin->options['umg_start_lcomments']) { $show['umg_lastcom'] = false; $mcolspan--; }

		$show['search'] = $show['errors'] = false;
		$searched = $db->query_read ("SELECT 
			m.*,ca.title AS cattitle,ca.userid AS gallery,ca.permission,ca.timestamp,u.username,co.commentcount  
			FROM " . TABLE_PREFIX . "umg_media AS m 
			LEFT JOIN " . TABLE_PREFIX. "umg_comment AS c ON (c.mediaid=m.mediaid) 
			LEFT JOIN " . TABLE_PREFIX . "umg_category AS ca ON (ca.catid=m.catid " . $search_timeshift . ") 
			LEFT JOIN " . TABLE_PREFIX . "umg_counts AS co ON (co.mediaid=m.mediaid) 
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=m.userid) 
			" . $tag_search . "
			WHERE " . $more_title_search . "
			" . $search_in_category . "
			" . $search_by_commentcount . "
			" . $search_by_date . "
			AND ca.catid IS NOT NULL 
			GROUP BY m.mediaid
			" . $order_by . "
		");
		$numitems = $db->num_rows ($searched);
		$db->free_result ($searched);

		if ($vbulletin->GPC['pagenumber'] < 1) $vbulletin->GPC['pagenumber'] = 1;
		$pagenumber = ($vbulletin->GPC['pagenumber'] > $numitems ? $numitems : $vbulletin->GPC['pagenumber']);
		$start = ($pagenumber - 1) * $lim;
		if ($start < 0) $start = 0;

		$search = $db->query_read ("SELECT 
			m.*,ca.title AS cattitle,ca.permission,ca.userid AS gallery,u.username,co.commentcount  
			FROM " . TABLE_PREFIX . "umg_media AS m 
			LEFT JOIN " . TABLE_PREFIX. "umg_comment AS c ON (c.mediaid=m.mediaid) 
			LEFT JOIN " . TABLE_PREFIX . "umg_category AS ca ON (ca.catid=m.catid " . $search_timeshift . ") 
			LEFT JOIN " . TABLE_PREFIX . "umg_counts AS co ON (co.mediaid=m.mediaid) 
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=m.userid) 
			" . $tag_search . "
			WHERE " . $more_title_search . "
			" . $search_in_category . "
			" . $search_by_commentcount . "
			" . $search_by_date . "
			AND ca.catid IS NOT NULL 
			GROUP BY m.mediaid
			" . $order_by . "
			LIMIT $start, $lim
		");

		$last = $start + $lim;
		if ($numitems < $lim) $last = $start + $numitems;
		$first = $start + 1;

		$items = $db->num_rows ($search);
		if (!$items)
		{
			$show['errors'] = true;
			$show['search'] = $show['results'] = false;
			$errors = array ('Can find any results.');
		}
		else
		{
			$med = $cansee = 0;
			if ($vbulletin->userinfo['editcomments'] OR $vbulletin->userinfo['deletecomments'] OR $vbulletin->userinfo['deletemedia']) $cansee = 1;

			$mcat = -1;
			$searchbits = '';
			$show['search'] = $show['results'] = true;
			while ($row = $db->fetch_array ($search))
			{
				if (in_array ($vbulletin->userinfo['usergroupid'], explode (',', $row['permission'])) OR $row['userid'] == $vbulletin->userinfo['userid'] OR $cansee)
				{
					$thumbnail = '&nbsp;';
					if ($show['umg_thumbs'])
					{
						$size = @getimagesize (DIR . '/umg_gallery/images/' . $row['gallery'] . '/small/' . $row['mediaid'] . '_' . $row['filename']);
						if (!$size[0]) $size[0] = 1;
						if (!$size[1]) $size[1] = 1;
						$ratio_w = 40 / $size[0];
						$ratio_h = 40 / $size[1];
						$ratio_m = min ($ratio_w, $ratio_h);
						$used_width  = $size[0];
						$used_height = $size[1];
						if ($ratio_m < 1)
						{
							$used_width  = round ($size[0]  * $ratio_m, 0);
							$used_height = round ($size[1] * $ratio_m, 0);
						}
						$thumbnail = '<img src="umg_view.php?' . $session['sessionurl'] . 'do=s&amp;mediaid=' . $row['mediaid'] . '" width="' . $used_width . 'px" height="' . $used_height . 'px" alt="' . $row['title'] . '" title="' . $row['title'] . '" border="0" />';
					}

					if ($show['umg_comments'])
					{
						if (!$row['commentcount']) $row['commentcount'] = 0;
					}
					$aa = '&nbsp;';
					if ($show['umg_lastcom'])
					{
					}

					$row['title'] = preg_replace('#(?<=[\s"\]>()\',;]|^)(' . $db->escape_string ($vbulletin->GPC['query']) . ')(([&\'.,:;-?!()\s"<\[]|$))#siU', '<vb_highlight>\\1</vb_highlight>\\2', $row['title']);
					$row['title'] = preg_replace('#<vb_highlight>(.*)</vb_highlight>#siU', '<span class="highlight">$1</span>', $row['title']);
					eval ('$searchbits .= "' . fetch_template ('umg_search_resultbit') . '";');
					$med++;
				}
			}
			if ($med)
			{
				$searchtime = vb_number_format (fetch_microtime_difference ($searchstart, microtime () - $searchstart), 2);
			}
			else
			{
				$show['errors'] = true;
				$show['search'] = $show['results'] = false;
				$errors = array ('Can find any results.');
			}
		}
	}
}

$childcategories = $sortorderselected = $sortbyselected = $beforeafterselected = $replylessselected = $exactnamechecked = $titleonlyselected = $searchdateselected = array ('', '', '', '', '', '', '', '');
$sortbyselected[$vbulletin->GPC['sortby']] = 'selected="selected"';
$exactnamechecked[$vbulletin->GPC['exactname']] = 'checked="checked"';
$titleonlyselected[$vbulletin->GPC['titleonly']] = 'selected="selected"';
$sortorderselected[$vbulletin->GPC['sortorder']] = 'selected="selected"';
$replylessselected[$vbulletin->GPC['replyless']] = 'selected="selected"';
$searchdateselected[$vbulletin->GPC['searchdate']] = 'selected="selected"';
$beforeafterselected[$vbulletin->GPC['beforeafter']] = 'selected="selected"';

if ($vbulletin->GPC['query']) $query = $vbulletin->GPC['query'];
if ($vbulletin->GPC['tag']) $formdata['tag'] = $vbulletin->GPC['tag'];
if ($vbulletin->GPC['searchuser']) $searchuser = $vbulletin->GPC['searchuser'];

$errorlist = '';
if ($show['errors'])
{
	foreach ($errors AS $error)
	{
		$errorlist .= "<li>$error</li>";
	}
}

if (!$show['search'])
{
	array_pop ($gallery_navbits);
	$gallery_navbits[] = $vbphrase['umg_gallery_search'];

	$ids = array ();
	$searchforumbits = '';
	if (($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canhavepublic'])) $ids[0] = '';
	if (($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canseeprivate']))
	{
		$stats = unserialize ($vbulletin->umg_statistics);
		foreach ($stats['private_users'] as $key => $val)
		{
			$ids[$key] = $val['username'];
		}
	}

	if (count ($ids))
	{
		$catids = array ();
		foreach ($ids AS $key => $val)
		{
			$x = 0;
			$upr_list = $list_upr = array ();
			umg_create_categorylist ($upr_list, $list_upr, -1, $vbphrase['umg_category_select_none'], 0, '', '-' , $key, 3);

			if ($key > 0) $searchforumbits .= "<option class=\"fjdpth0\" value=\"u." . $key . "\">" . "-:[ " . $val . " ]:-</option>\n";

			if (count ($upr_list))
			{
				foreach ($upr_list as $catid => $category)
				{
					if ($catid >= 1) $catids[] = $catid;
					if ($x > 0) $searchforumbits .= "<option value=\"" . $catid . "\">" . $category . "</option>\n";
					$x++;
				}
			}
		}
	}

	$show['tag_option'] = false;
	if (count ($catids))
	{
		$tags = $db->query ("SELECT 
			ta.tagid
			FROM " . TABLE_PREFIX . "umg_tag AS ta
			LEFT JOIN " . TABLE_PREFIX . "umg_tagmedia AS tm ON (tm.tagid=ta.tagid) 
			LEFT JOIN " . TABLE_PREFIX . "umg_media AS m ON (m.mediaid=tm.mediaid) 
			LEFT JOIN " . TABLE_PREFIX . "umg_category AS c ON (c.catid=m.catid) 
			WHERE c.catid IN (0," . implode (',', $catids) . ") 
		");
		if ($db->num_rows ($tags)) $show['tag_option'] = true;
	}

	eval ('$gallery_public = "' . fetch_template ('umg_search') . '";');
}

if ($show['results'])
{

	array_pop ($gallery_navbits);
	$gallery_navbits[] = $vbphrase['umg_gallery_search_results'];

	$pagenav = construct_page_nav ($pagenumber, $lim, $numitems, 'umg.php?' . $vbulletin->session->vars['sessionurl'] . "do=search&amp;act=find", ""
		. (!empty ($vbulletin->GPC['perpage']) ? "&amp;pp=$perpage" : '')
		. (!empty ($vbulletin->GPC['query']) ? "&amp;query=" . $vbulletin->GPC['query'] : '')
		. (!empty ($vbulletin->GPC['titleonly']) ? "&amp;titleonly=" . $vbulletin->GPC['titleonly'] : '')
		. (!empty ($vbulletin->GPC['searchuser']) ? "&amp;searchuser=" . $vbulletin->GPC['searchuser'] : '')
		. (!empty ($vbulletin->GPC['replyless']) ? "&amp;replyless=" . $vbulletin->GPC['replyless'] : '')
		. (!empty ($vbulletin->GPC['replylimit']) ? "&amp;replylimit=" . $vbulletin->GPC['replylimit'] : '')
		. (!empty ($vbulletin->GPC['searchdate']) ? "&amp;searchdate=" . $vbulletin->GPC['searchdate'] : '')
		. (!empty ($vbulletin->GPC['beforeafter']) ? "&amp;beforeafter=" . $vbulletin->GPC['beforeafter'] : '')
		. (!empty ($vbulletin->GPC['sortby']) ? "&amp;sortby=" . $vbulletin->GPC['sortby'] : '')
		. (!empty ($vbulletin->GPC['sortorder']) ? "&amp;sortorder=" . $vbulletin->GPC['sortorder'] : '')
		. (!empty ($vbulletin->GPC['tag']) ? "&amp;tag=" . $vbulletin->GPC['tag'] : '')
		. (!empty ($vbulletin->GPC['mediatype']) ? "&amp;mediatype=" . $vbulletin->GPC['mediatype'] : '')
		. (!empty ($vbulletin->GPC['childcategories']) ? "&amp;childcategories=" . $vbulletin->GPC['childcategories'] : '')
		. (!empty ($vbulletin->GPC['categorychoice']) ? "&amp;sc=" . implode (',', $cids) : '')
	);

	eval ('$gallery_public = "' . fetch_template ('umg_search_results') . '";');
}
?>
